/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.service;

import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.optional.OptionalFile;
import pro.gravit.launcher.base.profiles.optional.OptionalView;
import pro.gravit.launcher.core.LauncherNetworkAPI;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.runtime.client.DirBridge;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class ProfilesService {
    private final JavaFXApplication application;
    private List<ClientProfile> profiles;
    private ClientProfile profile;
    private Map<ClientProfile, OptionalView> optionalViewMap;

    public ProfilesService(JavaFXApplication application) {
        this.application = application;
    }

    public Map<ClientProfile, OptionalView> getOptionalViewMap() {
        return this.optionalViewMap;
    }

    public OptionalView getOptionalView() {
        return this.optionalViewMap.get(this.profile);
    }

    public OptionalView getOptionalView(ClientProfile profile) {
        return this.optionalViewMap.get(profile);
    }

    public void setOptionalView(ClientProfile profile, OptionalView view) {
        this.optionalViewMap.put(profile, view);
    }

    public void setProfilesResult(ProfilesRequestEvent rawProfilesResult) {
        this.profiles = rawProfilesResult.profiles;
        this.profiles.sort(ClientProfile::compareTo);
        if (this.optionalViewMap == null) {
            this.optionalViewMap = new HashMap<ClientProfile, OptionalView>();
        }
        for (ClientProfile profile : this.profiles) {
            profile.updateOptionalGraph();
            OptionalView oldView = this.optionalViewMap.get(profile);
            OptionalView newView = oldView != null ? new OptionalView(profile, oldView) : new OptionalView(profile);
            this.optionalViewMap.put(profile, newView);
        }
        for (ClientProfile profile : this.profiles) {
            this.application.triggerManager.process(profile, this.getOptionalView(profile));
        }
    }

    public List<ClientProfile> getProfiles() {
        return this.profiles;
    }

    public ClientProfile getProfile() {
        return this.profile;
    }

    public void setProfile(ClientProfile profile) {
        this.profile = profile;
    }

    public void saveAll() throws IOException {
        if (this.profiles == null) {
            return;
        }
        Path optionsFile = DirBridge.dir.resolve("options.json");
        ArrayList<OptionalListEntry> list = new ArrayList<OptionalListEntry>(5);
        for (ClientProfile clientProfile : this.profiles) {
            OptionalListEntry entry = new OptionalListEntry();
            entry.name = clientProfile.getTitle();
            entry.profileUUID = clientProfile.getUUID();
            OptionalView view = this.optionalViewMap.get(clientProfile);
            view.all.forEach(optionalFile -> {
                if (optionalFile.visible) {
                    boolean isEnabled = view.enabled.contains(optionalFile);
                    OptionalView.OptionalFileInstallInfo installInfo = (OptionalView.OptionalFileInstallInfo)view.installInfo.get(optionalFile);
                    entry.enabled.add(new OptionalListEntryPair((OptionalFile)optionalFile, isEnabled, installInfo));
                }
            });
            list.add(entry);
        }
        try (BufferedWriter writer = IOHelper.newWriter((Path)optionsFile);){
            Launcher.gsonManager.gson.toJson(list, (Appendable)writer);
        }
    }

    public void loadAll() throws IOException {
        if (this.profiles == null) {
            return;
        }
        Path optionsFile = DirBridge.dir.resolve("options.json");
        if (!Files.exists(optionsFile, new LinkOption[0])) {
            return;
        }
        Type collectionType = new TypeToken<List<OptionalListEntry>>(){}.getType();
        try (BufferedReader reader = IOHelper.newReader((Path)optionsFile);){
            List list = (List)Launcher.gsonManager.gson.fromJson((Reader)reader, collectionType);
            for (OptionalListEntry entry : list) {
                ClientProfile selectedProfile = null;
                for (ClientProfile clientProfile : this.profiles) {
                    if (!(entry.profileUUID != null ? entry.profileUUID.equals(clientProfile.getUUID()) : clientProfile.getTitle().equals(entry.name))) continue;
                    selectedProfile = clientProfile;
                }
                if (selectedProfile == null) {
                    LogHelper.warning((String)"Optional: profile %s(%s) not found", (Object[])new Object[]{entry.name, entry.profileUUID});
                    continue;
                }
                OptionalView view = this.optionalViewMap.get(selectedProfile);
                for (OptionalListEntryPair entryPair : entry.enabled) {
                    try {
                        OptionalFile file = selectedProfile.getOptionalFile(entryPair.name);
                        if (!file.visible) continue;
                        if (entryPair.mark) {
                            view.enable(file, entryPair.installInfo != null && entryPair.installInfo.isManual, null);
                            continue;
                        }
                        view.disable(file, null);
                    }
                    catch (Exception exc) {
                        LogHelper.warning((String)"Optional: in profile %s markOptional mod %s failed", (Object[])new Object[]{selectedProfile.getTitle(), entryPair.name});
                    }
                }
            }
        }
    }

    public static class OptionalListEntry {
        @LauncherNetworkAPI
        public List<OptionalListEntryPair> enabled = new LinkedList<OptionalListEntryPair>();
        @LauncherNetworkAPI
        public String name;
        @LauncherNetworkAPI
        public UUID profileUUID;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OptionalListEntry that = (OptionalListEntry)o;
            return Objects.equals(this.profileUUID, that.profileUUID) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.profileUUID);
        }
    }

    public static class OptionalListEntryPair {
        @LauncherNetworkAPI
        public String name;
        @LauncherNetworkAPI
        public boolean mark;
        @LauncherNetworkAPI
        public OptionalView.OptionalFileInstallInfo installInfo;

        public OptionalListEntryPair(OptionalFile optionalFile, boolean enabled, OptionalView.OptionalFileInstallInfo installInfo) {
            this.name = optionalFile.name;
            this.mark = enabled;
            this.installInfo = installInfo;
        }
    }
}

